typedef const unsigned short table_t[1024];

static const int prime_factor = 89, prime_step = 281;

static const struct value_desc values[] = {
    { 0,  },
    { GL_ALPHA_BITS, BUFFER_INT(Visual.alphaBits), extra_new_buffers },
    { GL_BLEND, CONTEXT_BIT0(Color.BlendEnabled), NO_EXTRA },
    { GL_BLEND_SRC, CONTEXT_ENUM(Color.Blend[0].SrcRGB), NO_EXTRA },
    { GL_BLUE_BITS, BUFFER_INT(Visual.blueBits), extra_new_buffers },
    { GL_COLOR_CLEAR_VALUE, LOC_CUSTOM, TYPE_FLOATN_4, 0, extra_new_frag_clamp },
    { GL_COLOR_WRITEMASK, LOC_CUSTOM, TYPE_INT_4, 0, NO_EXTRA },
    { GL_CULL_FACE, CONTEXT_BOOL(Polygon.CullFlag), NO_EXTRA },
    { GL_CULL_FACE_MODE, CONTEXT_ENUM(Polygon.CullFaceMode), NO_EXTRA },
    { GL_DEPTH_BITS, BUFFER_INT(Visual.depthBits), extra_new_buffers },
    { GL_DEPTH_CLEAR_VALUE, CONTEXT_FIELD(Depth.Clear, TYPE_DOUBLEN), NO_EXTRA },
    { GL_DEPTH_FUNC, CONTEXT_ENUM(Depth.Func), NO_EXTRA },
    { GL_DEPTH_RANGE, LOC_CUSTOM, TYPE_DOUBLEN_2, 0, NO_EXTRA },
    { GL_DEPTH_TEST, CONTEXT_BOOL(Depth.Test), NO_EXTRA },
    { GL_DEPTH_WRITEMASK, CONTEXT_BOOL(Depth.Mask), NO_EXTRA },
    { GL_DITHER, CONTEXT_BOOL(Color.DitherFlag), NO_EXTRA },
    { GL_FRONT_FACE, CONTEXT_ENUM(Polygon.FrontFace), NO_EXTRA },
    { GL_GREEN_BITS, BUFFER_INT(Visual.greenBits), extra_new_buffers },
    { GL_LINE_WIDTH, CONTEXT_FLOAT(Line.Width), NO_EXTRA },
    { GL_ALIASED_LINE_WIDTH_RANGE, CONTEXT_FLOAT2(Const.MinLineWidth), NO_EXTRA },
    { GL_MAX_ELEMENTS_VERTICES, CONTEXT_INT(Const.MaxArrayLockSize), NO_EXTRA },
    { GL_MAX_ELEMENTS_INDICES, CONTEXT_INT(Const.MaxArrayLockSize), NO_EXTRA },
    { GL_MAX_TEXTURE_SIZE, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, Const.MaxTextureLevels), NO_EXTRA },
    { GL_MAX_VIEWPORT_DIMS, CONTEXT_INT2(Const.MaxViewportWidth), NO_EXTRA },
    { GL_PACK_ALIGNMENT, CONTEXT_INT(Pack.Alignment), NO_EXTRA },
    { GL_ALIASED_POINT_SIZE_RANGE, CONTEXT_FLOAT2(Const.MinPointSize), NO_EXTRA },
    { GL_POLYGON_OFFSET_FACTOR, CONTEXT_FLOAT(Polygon.OffsetFactor ), NO_EXTRA },
    { GL_POLYGON_OFFSET_UNITS, CONTEXT_FLOAT(Polygon.OffsetUnits ), NO_EXTRA },
    { GL_POLYGON_OFFSET_FILL, CONTEXT_BOOL(Polygon.OffsetFill), NO_EXTRA },
    { GL_RED_BITS, BUFFER_INT(Visual.redBits), extra_new_buffers },
    { GL_SCISSOR_BOX, LOC_CUSTOM, TYPE_INT_4, 0, NO_EXTRA },
    { GL_SCISSOR_TEST, LOC_CUSTOM, TYPE_BOOLEAN, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_BITS, BUFFER_INT(Visual.stencilBits), extra_new_buffers },
    { GL_STENCIL_CLEAR_VALUE, CONTEXT_INT(Stencil.Clear), NO_EXTRA },
    { GL_STENCIL_FAIL, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_FUNC, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_PASS_DEPTH_FAIL, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_PASS_DEPTH_PASS, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_REF, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_TEST, CONTEXT_BOOL(Stencil.Enabled), NO_EXTRA },
    { GL_STENCIL_VALUE_MASK, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_WRITEMASK, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_SUBPIXEL_BITS, CONTEXT_INT(Const.SubPixelBits), NO_EXTRA },
    { GL_TEXTURE_BINDING_2D, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_INDEX, NO_EXTRA },
    { GL_UNPACK_ALIGNMENT, CONTEXT_INT(Unpack.Alignment), NO_EXTRA },
    { GL_VIEWPORT, LOC_CUSTOM, TYPE_FLOAT_4, 0, NO_EXTRA },
    { GL_ACTIVE_TEXTURE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_TEXTURE_BINDING_CUBE_MAP_ARB, LOC_CUSTOM, TYPE_INT, TEXTURE_CUBE_INDEX, extra_ARB_texture_cube_map },
    { GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, Const.MaxCubeTextureLevels), extra_ARB_texture_cube_map },
    { GL_BLEND_SRC_RGB, CONTEXT_ENUM(Color.Blend[0].SrcRGB), NO_EXTRA },
    { GL_BLEND_DST_RGB, CONTEXT_ENUM(Color.Blend[0].DstRGB), NO_EXTRA },
    { GL_BLEND_SRC_ALPHA, CONTEXT_ENUM(Color.Blend[0].SrcA), NO_EXTRA },
    { GL_BLEND_DST_ALPHA, CONTEXT_ENUM(Color.Blend[0].DstA), NO_EXTRA },
    { GL_BLEND_EQUATION, CONTEXT_ENUM(Color.Blend[0].EquationRGB), NO_EXTRA },
    { GL_BLEND_EQUATION_ALPHA_EXT, CONTEXT_ENUM(Color.Blend[0].EquationA), NO_EXTRA },
    { GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_COMPRESSED_TEXTURE_FORMATS, LOC_CUSTOM, TYPE_INT_N, 0, NO_EXTRA },
    { GL_SAMPLE_ALPHA_TO_COVERAGE_ARB, CONTEXT_BOOL(Multisample.SampleAlphaToCoverage), NO_EXTRA },
    { GL_SAMPLE_COVERAGE_ARB, CONTEXT_BOOL(Multisample.SampleCoverage), NO_EXTRA },
    { GL_SAMPLE_COVERAGE_VALUE_ARB, CONTEXT_FLOAT(Multisample.SampleCoverageValue), NO_EXTRA },
    { GL_SAMPLE_COVERAGE_INVERT_ARB, CONTEXT_BOOL(Multisample.SampleCoverageInvert), NO_EXTRA },
    { GL_SAMPLE_BUFFERS_ARB, BUFFER_INT(Visual.sampleBuffers), extra_new_buffers },
    { GL_SAMPLES_ARB, BUFFER_INT(Visual.samples), extra_new_buffers },
    { GL_SAMPLE_SHADING_ARB, CONTEXT_BOOL(Multisample.SampleShading), extra_gl40_ARB_sample_shading },
    { GL_MIN_SAMPLE_SHADING_VALUE_ARB, CONTEXT_FLOAT(Multisample.MinSampleShadingValue), extra_gl40_ARB_sample_shading },
    { GL_GENERATE_MIPMAP_HINT_SGIS, CONTEXT_ENUM(Hint.GenerateMipmap), NO_EXTRA },
    { GL_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_CLAMP_VERTEX_COLOR, CONTEXT_ENUM(Light.ClampVertexColor), extra_ARB_color_buffer_float },
    { GL_CLAMP_FRAGMENT_COLOR, CONTEXT_ENUM(Color.ClampFragmentColor), extra_ARB_color_buffer_float },
    { GL_CLAMP_READ_COLOR, CONTEXT_ENUM(Color.ClampReadColor), extra_ARB_color_buffer_float_or_glcore },
    { GL_COPY_READ_BUFFER, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_COPY_WRITE_BUFFER, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_IMPLEMENTATION_COLOR_READ_TYPE_OES, LOC_CUSTOM, TYPE_INT, 0, extra_new_buffers },
    { GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES, LOC_CUSTOM, TYPE_INT, 0, extra_new_buffers },
    { GL_FRAMEBUFFER_BINDING_EXT, BUFFER_INT(Name), NO_EXTRA },
    { GL_RENDERBUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MAX_RENDERBUFFER_SIZE_EXT, CONTEXT_INT(Const.MaxRenderbufferSize), NO_EXTRA },
    { GL_MAX_CLIP_PLANES, CONTEXT_INT(Const.MaxClipPlanes), NO_EXTRA },
    { GL_VERTEX_ARRAY_BINDING_APPLE, ARRAY_INT(Name), NO_EXTRA },
    { GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, CONTEXT_FLOAT(Const.MaxTextureMaxAnisotropy), extra_EXT_texture_filter_anisotropic },
    { GL_MAX_LIGHTS, CONTEXT_INT(Const.MaxLights), NO_EXTRA },
    { GL_LIGHT0, CONTEXT_BOOL(Light.Light[0].Enabled), NO_EXTRA },
    { GL_LIGHT1, CONTEXT_BOOL(Light.Light[1].Enabled), NO_EXTRA },
    { GL_LIGHT2, CONTEXT_BOOL(Light.Light[2].Enabled), NO_EXTRA },
    { GL_LIGHT3, CONTEXT_BOOL(Light.Light[3].Enabled), NO_EXTRA },
    { GL_LIGHT4, CONTEXT_BOOL(Light.Light[4].Enabled), NO_EXTRA },
    { GL_LIGHT5, CONTEXT_BOOL(Light.Light[5].Enabled), NO_EXTRA },
    { GL_LIGHT6, CONTEXT_BOOL(Light.Light[6].Enabled), NO_EXTRA },
    { GL_LIGHT7, CONTEXT_BOOL(Light.Light[7].Enabled), NO_EXTRA },
    { GL_LIGHTING, CONTEXT_BOOL(Light.Enabled), NO_EXTRA },
    { GL_LIGHT_MODEL_AMBIENT, CONTEXT_FIELD(Light.Model.Ambient[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_LIGHT_MODEL_TWO_SIDE, CONTEXT_BOOL(Light.Model.TwoSide), NO_EXTRA },
    { GL_ALPHA_TEST, CONTEXT_BOOL(Color.AlphaEnabled), NO_EXTRA },
    { GL_ALPHA_TEST_FUNC, CONTEXT_ENUM(Color.AlphaFunc), NO_EXTRA },
    { GL_ALPHA_TEST_REF, LOC_CUSTOM, TYPE_FLOATN, 0, extra_new_frag_clamp },
    { GL_BLEND_DST, CONTEXT_ENUM(Color.Blend[0].DstRGB), NO_EXTRA },
    { GL_CLIP_DISTANCE0, CONTEXT_BIT0(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE1, CONTEXT_BIT1(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE2, CONTEXT_BIT2(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE3, CONTEXT_BIT3(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE4, CONTEXT_BIT4(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE5, CONTEXT_BIT5(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE6, CONTEXT_BIT6(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE7, CONTEXT_BIT7(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_COLOR_MATERIAL, CONTEXT_BOOL(Light.ColorMaterialEnabled), NO_EXTRA },
    { GL_CURRENT_COLOR, CONTEXT_FIELD(Current.Attrib[VERT_ATTRIB_COLOR0][0], TYPE_FLOATN_4), extra_flush_current },
    { GL_CURRENT_NORMAL, CONTEXT_FIELD(Current.Attrib[VERT_ATTRIB_NORMAL][0], TYPE_FLOATN_3), extra_flush_current },
    { GL_CURRENT_TEXTURE_COORDS, LOC_CUSTOM, TYPE_FLOAT_4, 0, extra_flush_current_valid_texture_unit },
    { GL_POINT_DISTANCE_ATTENUATION, CONTEXT_FLOAT3(Point.Params[0]), NO_EXTRA },
    { GL_FOG, CONTEXT_BOOL(Fog.Enabled), NO_EXTRA },
    { GL_FOG_COLOR, LOC_CUSTOM, TYPE_FLOATN_4, 0, extra_new_frag_clamp },
    { GL_FOG_DENSITY, CONTEXT_FLOAT(Fog.Density), NO_EXTRA },
    { GL_FOG_END, CONTEXT_FLOAT(Fog.End), NO_EXTRA },
    { GL_FOG_HINT, CONTEXT_ENUM(Hint.Fog), NO_EXTRA },
    { GL_FOG_MODE, CONTEXT_ENUM(Fog.Mode), NO_EXTRA },
    { GL_FOG_START, CONTEXT_FLOAT(Fog.Start), NO_EXTRA },
    { GL_LINE_SMOOTH, CONTEXT_BOOL(Line.SmoothFlag), NO_EXTRA },
    { GL_LINE_SMOOTH_HINT, CONTEXT_ENUM(Hint.LineSmooth), NO_EXTRA },
    { GL_LINE_WIDTH_RANGE, CONTEXT_FLOAT2(Const.MinLineWidthAA), NO_EXTRA },
    { GL_COLOR_LOGIC_OP, CONTEXT_BOOL(Color.ColorLogicOpEnabled), NO_EXTRA },
    { GL_LOGIC_OP_MODE, CONTEXT_ENUM(Color.LogicOp), NO_EXTRA },
    { GL_MATRIX_MODE, CONTEXT_ENUM(Transform.MatrixMode), NO_EXTRA },
    { GL_MAX_MODELVIEW_STACK_DEPTH, CONST(MAX_MODELVIEW_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_PROJECTION_STACK_DEPTH, CONST(MAX_PROJECTION_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_TEXTURE_STACK_DEPTH, CONST(MAX_TEXTURE_STACK_DEPTH), NO_EXTRA },
    { GL_MODELVIEW_MATRIX, CONTEXT_MATRIX(ModelviewMatrixStack.Top), NO_EXTRA },
    { GL_MODELVIEW_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, ModelviewMatrixStack.Depth), NO_EXTRA },
    { GL_NORMALIZE, CONTEXT_BOOL(Transform.Normalize), NO_EXTRA },
    { GL_PACK_SKIP_IMAGES, CONTEXT_INT(Pack.SkipImages), NO_EXTRA },
    { GL_PERSPECTIVE_CORRECTION_HINT, CONTEXT_ENUM(Hint.PerspectiveCorrection), NO_EXTRA },
    { GL_POINT_SIZE, CONTEXT_FLOAT(Point.Size), NO_EXTRA },
    { GL_POINT_SIZE_RANGE, CONTEXT_FLOAT2(Const.MinPointSizeAA), NO_EXTRA },
    { GL_POINT_SMOOTH, CONTEXT_BOOL(Point.SmoothFlag), NO_EXTRA },
    { GL_POINT_SMOOTH_HINT, CONTEXT_ENUM(Hint.PointSmooth), NO_EXTRA },
    { GL_POINT_SIZE_MIN_EXT, CONTEXT_FLOAT(Point.MinSize), NO_EXTRA },
    { GL_POINT_SIZE_MAX_EXT, CONTEXT_FLOAT(Point.MaxSize), NO_EXTRA },
    { GL_POINT_FADE_THRESHOLD_SIZE_EXT, CONTEXT_FLOAT(Point.Threshold), NO_EXTRA },
    { GL_PROJECTION_MATRIX, CONTEXT_MATRIX(ProjectionMatrixStack.Top), NO_EXTRA },
    { GL_PROJECTION_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, ProjectionMatrixStack.Depth), NO_EXTRA },
    { GL_RESCALE_NORMAL, CONTEXT_BOOL(Transform.RescaleNormals), NO_EXTRA },
    { GL_SHADE_MODEL, CONTEXT_ENUM(Light.ShadeModel), NO_EXTRA },
    { GL_TEXTURE_2D, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_TEXTURE_MATRIX, LOC_CUSTOM, TYPE_MATRIX, 0, extra_valid_texture_unit },
    { GL_TEXTURE_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, 0, extra_valid_texture_unit },
    { GL_VERTEX_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_POS].Enabled), NO_EXTRA },
    { GL_VERTEX_ARRAY_SIZE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_POS].Size), NO_EXTRA },
    { GL_VERTEX_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_POS].Type), NO_EXTRA },
    { GL_VERTEX_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_POS].Stride), NO_EXTRA },
    { GL_NORMAL_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_NORMAL].Enabled), NO_EXTRA },
    { GL_NORMAL_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_NORMAL].Type), NO_EXTRA },
    { GL_NORMAL_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_NORMAL].Stride), NO_EXTRA },
    { GL_COLOR_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_COLOR0].Enabled), NO_EXTRA },
    { GL_COLOR_ARRAY_SIZE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_COLOR_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_COLOR0].Type), NO_EXTRA },
    { GL_COLOR_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_COLOR0].Stride), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY, LOC_CUSTOM, TYPE_BOOLEAN, offsetof(struct gl_vertex_attrib_array, Enabled), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_SIZE, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_attrib_array, Size), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_TYPE, LOC_CUSTOM, TYPE_ENUM, offsetof(struct gl_vertex_attrib_array, Type), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_STRIDE, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_attrib_array, Stride), NO_EXTRA },
    { GL_MAX_TEXTURE_UNITS, CONTEXT_INT(Const.MaxTextureUnits), NO_EXTRA },
    { GL_CLIENT_ACTIVE_TEXTURE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_TEXTURE_CUBE_MAP_ARB, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_TEXTURE_GEN_STR_OES, LOC_TEXUNIT, TYPE_BIT_0, offsetof(struct gl_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_MULTISAMPLE_ARB, CONTEXT_BOOL(Multisample.Enabled), NO_EXTRA },
    { GL_SAMPLE_ALPHA_TO_ONE_ARB, CONTEXT_BOOL(Multisample.SampleAlphaToOne), NO_EXTRA },
    { GL_VERTEX_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_POS].BufferObj), NO_EXTRA },
    { GL_NORMAL_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_NORMAL].BufferObj), NO_EXTRA },
    { GL_COLOR_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_COLOR0].BufferObj), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_POINT_SPRITE_NV, CONTEXT_BOOL(Point.PointSprite), extra_NV_point_sprite_ARB_point_sprite },
    { GL_POINT_SIZE_ARRAY_OES, ARRAY_FIELD(VertexAttrib[VERT_ATTRIB_POINT_SIZE].Enabled, TYPE_BOOLEAN) },
    { GL_POINT_SIZE_ARRAY_TYPE_OES, ARRAY_FIELD(VertexAttrib[VERT_ATTRIB_POINT_SIZE].Type, TYPE_ENUM) },
    { GL_POINT_SIZE_ARRAY_STRIDE_OES, ARRAY_FIELD(VertexAttrib[VERT_ATTRIB_POINT_SIZE].Stride, TYPE_INT) },
    { GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES, LOC_CUSTOM, TYPE_INT, 0 },
    { GL_MAX_TEXTURE_COORDS_ARB, CONTEXT_INT(Const.MaxTextureCoordUnits), extra_ARB_fragment_program },
    { GL_PACK_IMAGE_HEIGHT, CONTEXT_INT(Pack.ImageHeight), NO_EXTRA },
    { GL_PACK_ROW_LENGTH, CONTEXT_INT(Pack.RowLength), NO_EXTRA },
    { GL_PACK_SKIP_PIXELS, CONTEXT_INT(Pack.SkipPixels), NO_EXTRA },
    { GL_PACK_SKIP_ROWS, CONTEXT_INT(Pack.SkipRows), NO_EXTRA },
    { GL_UNPACK_ROW_LENGTH, CONTEXT_INT(Unpack.RowLength), NO_EXTRA },
    { GL_UNPACK_SKIP_PIXELS, CONTEXT_INT(Unpack.SkipPixels), NO_EXTRA },
    { GL_UNPACK_SKIP_ROWS, CONTEXT_INT(Unpack.SkipRows), NO_EXTRA },
    { GL_UNPACK_SKIP_IMAGES, CONTEXT_INT(Unpack.SkipImages), NO_EXTRA },
    { GL_UNPACK_IMAGE_HEIGHT, CONTEXT_INT(Unpack.ImageHeight), NO_EXTRA },
    { GL_MAX_DRAW_BUFFERS_ARB, CONTEXT_INT(Const.MaxDrawBuffers), NO_EXTRA },
    { GL_MAX_COLOR_ATTACHMENTS, CONTEXT_INT(Const.MaxColorAttachments), NO_EXTRA },
    { GL_DRAW_BUFFER0_ARB, BUFFER_ENUM(ColorDrawBuffer[0]), NO_EXTRA },
    { GL_DRAW_BUFFER1_ARB, BUFFER_ENUM(ColorDrawBuffer[1]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER2_ARB, BUFFER_ENUM(ColorDrawBuffer[2]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER3_ARB, BUFFER_ENUM(ColorDrawBuffer[3]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER4_ARB, BUFFER_ENUM(ColorDrawBuffer[4]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER5_ARB, BUFFER_ENUM(ColorDrawBuffer[5]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER6_ARB, BUFFER_ENUM(ColorDrawBuffer[6]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER7_ARB, BUFFER_ENUM(ColorDrawBuffer[7]), extra_valid_draw_buffer },
    { GL_BLEND_COLOR_EXT, LOC_CUSTOM, TYPE_FLOATN_4, 0, extra_new_frag_clamp },
    { GL_MAX_TEXTURE_IMAGE_UNITS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxTextureImageUnits), extra_ARB_fragment_program },
    { GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxTextureImageUnits), extra_ARB_vertex_shader },
    { GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB, CONTEXT_INT(Const.MaxCombinedTextureImageUnits), extra_ARB_vertex_shader },
    { GL_CURRENT_PROGRAM, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_STENCIL_BACK_FUNC, CONTEXT_ENUM(Stencil.Function[1]), NO_EXTRA },
    { GL_STENCIL_BACK_VALUE_MASK, CONTEXT_INT(Stencil.ValueMask[1]), NO_EXTRA },
    { GL_STENCIL_BACK_WRITEMASK, CONTEXT_INT(Stencil.WriteMask[1]), NO_EXTRA },
    { GL_STENCIL_BACK_REF, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_BACK_FAIL, CONTEXT_ENUM(Stencil.FailFunc[1]), NO_EXTRA },
    { GL_STENCIL_BACK_PASS_DEPTH_FAIL, CONTEXT_ENUM(Stencil.ZFailFunc[1]), NO_EXTRA },
    { GL_STENCIL_BACK_PASS_DEPTH_PASS, CONTEXT_ENUM(Stencil.ZPassFunc[1]), NO_EXTRA },
    { GL_MAX_VERTEX_ATTRIBS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxAttribs), extra_ARB_vertex_program_api_es2 },
    { GL_TEXTURE_BINDING_3D, LOC_CUSTOM, TYPE_INT, TEXTURE_3D_INDEX, NO_EXTRA },
    { GL_MAX_3D_TEXTURE_SIZE, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, Const.Max3DTextureLevels), NO_EXTRA },
    { GL_FRAGMENT_SHADER_DERIVATIVE_HINT, CONTEXT_ENUM(Hint.FragmentShaderDerivative), extra_ARB_fragment_shader },
    { GL_READ_BUFFER, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, extra_NV_read_buffer_api_gl },
    { GL_SHADER_COMPILER, CONST(1), extra_ARB_ES2_compatibility_api_es2 },
    { GL_MAX_VARYING_VECTORS, CONTEXT_INT(Const.MaxVarying), extra_ARB_ES2_compatibility_api_es2 },
    { GL_MAX_VERTEX_UNIFORM_VECTORS, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_ES2_compatibility_api_es2 },
    { GL_MAX_FRAGMENT_UNIFORM_VECTORS, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_ES2_compatibility_api_es2 },
    { GL_NUM_SHADER_BINARY_FORMATS, CONST(0), extra_ARB_ES2_compatibility_api_es2 },
    { GL_SHADER_BINARY_FORMATS, LOC_CUSTOM, TYPE_INVALID, 0, extra_ARB_ES2_compatibility_api_es2 },
    { GL_NUM_PROGRAM_BINARY_FORMATS, CONST(0), NO_EXTRA },
    { GL_PROGRAM_BINARY_FORMATS, LOC_CUSTOM, TYPE_INVALID, 0, NO_EXTRA },
    { GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL, CONST(MAX_PERFQUERY_QUERY_NAME_LENGTH), extra_INTEL_performance_query },
    { GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL, CONST(MAX_PERFQUERY_COUNTER_NAME_LENGTH), extra_INTEL_performance_query },
    { GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL, CONST(MAX_PERFQUERY_COUNTER_DESC_LENGTH), extra_INTEL_performance_query },
    { GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL, CONST(PERFQUERY_HAVE_GPA_EXTENDED_COUNTERS), extra_INTEL_performance_query },
    { GL_CONTEXT_RELEASE_BEHAVIOR, CONTEXT_ENUM(Const.ContextReleaseBehavior), NO_EXTRA },
    { GL_MAX_TEXTURE_LOD_BIAS_EXT, CONTEXT_FLOAT(Const.MaxTextureLodBias), NO_EXTRA },
    { GL_NUM_EXTENSIONS, LOC_CUSTOM, TYPE_INT, 0, extra_gl30_es3 },
    { GL_MAJOR_VERSION, LOC_CUSTOM, TYPE_INT, 0, extra_gl30_es3 },
    { GL_MINOR_VERSION, LOC_CUSTOM, TYPE_INT, 0, extra_gl30_es3 },
    { GL_MAX_VERTEX_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxOutputComponents), extra_gl32_es3 },
    { GL_MAX_FRAGMENT_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxInputComponents), extra_gl32_es3 },
    { GL_MAX_ELEMENT_INDEX, CONTEXT_INT64(Const.MaxElementIndex), extra_ARB_ES3_compatibility_api_es3 },
    { GL_PRIMITIVE_RESTART_FIXED_INDEX, CONTEXT_BOOL(Array.PrimitiveRestartFixedIndex), extra_ARB_ES3_compatibility_api_es3 },
    { GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxUniformComponents), extra_ARB_fragment_shader },
    { GL_MAX_SAMPLES, CONTEXT_INT(Const.MaxSamples), extra_ARB_framebuffer_object_EXT_framebuffer_multisample },
    { GL_SAMPLER_BINDING, LOC_CUSTOM, TYPE_INT, GL_SAMPLER_BINDING, NO_EXTRA },
    { GL_MAX_SERVER_WAIT_TIMEOUT, CONTEXT_INT64(Const.MaxServerWaitTimeout), extra_ARB_sync },
    { GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_ARB_transform_feedback2_api_es3 },
    { GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_ARB_transform_feedback2_api_es3 },
    { GL_TRANSFORM_FEEDBACK_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_transform_feedback2_api_es3 },
    { GL_MAX_VERTEX_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxUniformBlocks), extra_ARB_uniform_buffer_object },
    { GL_MAX_FRAGMENT_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxUniformBlocks), extra_ARB_uniform_buffer_object },
    { GL_MAX_COMBINED_UNIFORM_BLOCKS, CONTEXT_INT(Const.MaxCombinedUniformBlocks), extra_ARB_uniform_buffer_object },
    { GL_MAX_UNIFORM_BLOCK_SIZE, CONTEXT_INT(Const.MaxUniformBlockSize), extra_ARB_uniform_buffer_object },
    { GL_MAX_UNIFORM_BUFFER_BINDINGS, CONTEXT_INT(Const.MaxUniformBufferBindings), extra_ARB_uniform_buffer_object },
    { GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxCombinedUniformComponents), extra_ARB_uniform_buffer_object },
    { GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxCombinedUniformComponents), extra_ARB_uniform_buffer_object },
    { GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT, CONTEXT_INT(Const.UniformBufferOffsetAlignment), extra_ARB_uniform_buffer_object },
    { GL_UNIFORM_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_uniform_buffer_object },
    { GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxUniformComponents), extra_ARB_vertex_shader },
    { GL_MAX_VARYING_FLOATS_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_vertex_shader },
    { GL_READ_FRAMEBUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MIN_PROGRAM_TEXEL_OFFSET, CONTEXT_INT(Const.MinProgramTexelOffset), extra_GLSL_130_es3 },
    { GL_MAX_PROGRAM_TEXEL_OFFSET, CONTEXT_INT(Const.MaxProgramTexelOffset), extra_GLSL_130_es3 },
    { GL_PIXEL_PACK_BUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, extra_EXT_pixel_buffer_object },
    { GL_PIXEL_UNPACK_BUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, extra_EXT_pixel_buffer_object },
    { GL_TEXTURE_BINDING_2D_ARRAY, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_ARRAY_INDEX, extra_EXT_texture_array_es3 },
    { GL_MAX_ARRAY_TEXTURE_LAYERS_EXT, CONTEXT_INT(Const.MaxArrayTextureLayers), extra_EXT_texture_array_es3 },
    { GL_TRANSFORM_FEEDBACK_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_EXT_transform_feedback },
    { GL_RASTERIZER_DISCARD, CONTEXT_BOOL(RasterDiscard), extra_EXT_transform_feedback },
    { GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS, CONTEXT_INT(Const.MaxTransformFeedbackInterleavedComponents), extra_EXT_transform_feedback },
    { GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS, CONTEXT_INT(Const.MaxTransformFeedbackBuffers), extra_EXT_transform_feedback },
    { GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS, CONTEXT_INT(Const.MaxTransformFeedbackSeparateComponents), extra_EXT_transform_feedback },
    { GL_TEXTURE_BINDING_EXTERNAL_OES, LOC_CUSTOM, TYPE_INT, TEXTURE_EXTERNAL_INDEX, extra_OES_EGL_image_external },
    { GL_TEXTURE_EXTERNAL_OES, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_OES_EGL_image_external },
    { GL_MAX_IMAGE_UNITS, CONTEXT_INT(Const.MaxImageUnits), extra_ARB_shader_image_load_store_es31 },
    { GL_MAX_VERTEX_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxImageUniforms), extra_ARB_shader_image_load_store_es31 },
    { GL_MAX_FRAGMENT_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxImageUniforms), extra_ARB_shader_image_load_store_es31 },
    { GL_MAX_COMBINED_IMAGE_UNIFORMS, CONTEXT_INT(Const.MaxCombinedImageUniforms), extra_ARB_shader_image_load_store_es31 },
    { GL_ATOMIC_COUNTER_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS, CONTEXT_INT(Const.MaxAtomicBufferBindings), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE, CONTEXT_INT(Const.MaxAtomicBufferSize), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_VERTEX_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxAtomicCounters), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_FRAGMENT_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxAtomicCounters), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.MaxCombinedAtomicBuffers), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_COMBINED_ATOMIC_COUNTERS, CONTEXT_INT(Const.MaxCombinedAtomicCounters), extra_ARB_shader_atomic_counters_es31 },
    { GL_TEXTURE_BINDING_2D_MULTISAMPLE, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_MULTISAMPLE_INDEX, extra_ARB_texture_multisample_es31 },
    { GL_MAX_COLOR_TEXTURE_SAMPLES, CONTEXT_INT(Const.MaxColorTextureSamples), extra_ARB_texture_multisample_es31 },
    { GL_MAX_DEPTH_TEXTURE_SAMPLES, CONTEXT_INT(Const.MaxDepthTextureSamples), extra_ARB_texture_multisample_es31 },
    { GL_MAX_INTEGER_SAMPLES, CONTEXT_INT(Const.MaxIntegerSamples), extra_ARB_texture_multisample_es31 },
    { GL_SAMPLE_MASK, CONTEXT_BOOL(Multisample.SampleMask), extra_ARB_texture_multisample_es31 },
    { GL_MAX_SAMPLE_MASK_WORDS, CONST(1), extra_ARB_texture_multisample_es31 },
    { GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET, CONTEXT_INT(Const.MinProgramTextureGatherOffset), extra_ARB_texture_gather_es31 },
    { GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET, CONTEXT_INT(Const.MaxProgramTextureGatherOffset), extra_ARB_texture_gather_es31 },
    { GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS, CONTEXT_INT(Const.MaxComputeWorkGroupInvocations), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_UNIFORM_BLOCKS, CONST(MAX_COMPUTE_UNIFORM_BLOCKS), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS, CONST(MAX_COMPUTE_TEXTURE_IMAGE_UNITS), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS, CONST(MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_ATOMIC_COUNTERS, CONST(MAX_COMPUTE_ATOMIC_COUNTERS), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_SHARED_MEMORY_SIZE, CONST(MAX_COMPUTE_SHARED_MEMORY_SIZE), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_UNIFORM_COMPONENTS, CONST(MAX_COMPUTE_UNIFORM_COMPONENTS), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_IMAGE_UNIFORMS, CONST(MAX_COMPUTE_IMAGE_UNIFORMS), extra_ARB_compute_shader_es31 },
    { GL_MAX_UNIFORM_LOCATIONS, CONTEXT_INT(Const.MaxUserAssignableUniformLocations), extra_ARB_explicit_uniform_location_es31 },
    { GL_DRAW_INDIRECT_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_draw_indirect_es31 },
    { GL_ACCUM_RED_BITS, BUFFER_INT(Visual.accumRedBits), NO_EXTRA },
    { GL_ACCUM_GREEN_BITS, BUFFER_INT(Visual.accumGreenBits), NO_EXTRA },
    { GL_ACCUM_BLUE_BITS, BUFFER_INT(Visual.accumBlueBits), NO_EXTRA },
    { GL_ACCUM_ALPHA_BITS, BUFFER_INT(Visual.accumAlphaBits), NO_EXTRA },
    { GL_ACCUM_CLEAR_VALUE, CONTEXT_FIELD(Accum.ClearColor[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_ALPHA_BIAS, CONTEXT_FLOAT(Pixel.AlphaBias), NO_EXTRA },
    { GL_ALPHA_SCALE, CONTEXT_FLOAT(Pixel.AlphaScale), NO_EXTRA },
    { GL_ATTRIB_STACK_DEPTH, CONTEXT_INT(AttribStackDepth), NO_EXTRA },
    { GL_AUTO_NORMAL, CONTEXT_BOOL(Eval.AutoNormal), NO_EXTRA },
    { GL_AUX_BUFFERS, BUFFER_INT(Visual.numAuxBuffers), NO_EXTRA },
    { GL_BLUE_BIAS, CONTEXT_FLOAT(Pixel.BlueBias), NO_EXTRA },
    { GL_BLUE_SCALE, CONTEXT_FLOAT(Pixel.BlueScale), NO_EXTRA },
    { GL_CLIP_DEPTH_MODE, CONTEXT_ENUM(Transform.ClipDepthMode), extra_ARB_clip_control },
    { GL_CLIP_ORIGIN, CONTEXT_ENUM(Transform.ClipOrigin), extra_ARB_clip_control },
    { GL_CLIENT_ATTRIB_STACK_DEPTH, CONTEXT_INT(ClientAttribStackDepth), NO_EXTRA },
    { GL_COLOR_MATERIAL_FACE, CONTEXT_ENUM(Light.ColorMaterialFace), NO_EXTRA },
    { GL_COLOR_MATERIAL_PARAMETER, CONTEXT_ENUM(Light.ColorMaterialMode), NO_EXTRA },
    { GL_CURRENT_INDEX, CONTEXT_FLOAT(Current.Attrib[VERT_ATTRIB_COLOR_INDEX][0]), extra_flush_current },
    { GL_CURRENT_RASTER_COLOR, CONTEXT_FIELD(Current.RasterColor[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_CURRENT_RASTER_DISTANCE, CONTEXT_FLOAT(Current.RasterDistance), NO_EXTRA },
    { GL_CURRENT_RASTER_INDEX, CONST(1), NO_EXTRA },
    { GL_CURRENT_RASTER_POSITION, CONTEXT_FLOAT4(Current.RasterPos[0]), NO_EXTRA },
    { GL_CURRENT_RASTER_SECONDARY_COLOR, CONTEXT_FIELD(Current.RasterSecondaryColor[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_CURRENT_RASTER_TEXTURE_COORDS, LOC_CUSTOM, TYPE_FLOAT_4, 0, extra_valid_texture_unit },
    { GL_CURRENT_RASTER_POSITION_VALID, CONTEXT_BOOL(Current.RasterPosValid), NO_EXTRA },
    { GL_DEPTH_BIAS, CONTEXT_FLOAT(Pixel.DepthBias), NO_EXTRA },
    { GL_DEPTH_SCALE, CONTEXT_FLOAT(Pixel.DepthScale), NO_EXTRA },
    { GL_DOUBLEBUFFER, BUFFER_INT(Visual.doubleBufferMode), NO_EXTRA },
    { GL_DRAW_BUFFER, BUFFER_ENUM(ColorDrawBuffer[0]), NO_EXTRA },
    { GL_EDGE_FLAG, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_flush_current },
    { GL_FEEDBACK_BUFFER_SIZE, CONTEXT_INT(Feedback.BufferSize), NO_EXTRA },
    { GL_FEEDBACK_BUFFER_TYPE, CONTEXT_ENUM(Feedback.Type), NO_EXTRA },
    { GL_FOG_INDEX, CONTEXT_FLOAT(Fog.Index), NO_EXTRA },
    { GL_GREEN_BIAS, CONTEXT_FLOAT(Pixel.GreenBias), NO_EXTRA },
    { GL_GREEN_SCALE, CONTEXT_FLOAT(Pixel.GreenScale), NO_EXTRA },
    { GL_INDEX_BITS, BUFFER_INT(Visual.indexBits), extra_new_buffers },
    { GL_INDEX_CLEAR_VALUE, CONTEXT_INT(Color.ClearIndex), NO_EXTRA },
    { GL_INDEX_MODE, CONST(0) , NO_EXTRA },
    { GL_INDEX_OFFSET, CONTEXT_INT(Pixel.IndexOffset), NO_EXTRA },
    { GL_INDEX_SHIFT, CONTEXT_INT(Pixel.IndexShift), NO_EXTRA },
    { GL_INDEX_WRITEMASK, CONTEXT_INT(Color.IndexMask), NO_EXTRA },
    { GL_LIGHT_MODEL_COLOR_CONTROL, CONTEXT_ENUM(Light.Model.ColorControl), NO_EXTRA },
    { GL_LIGHT_MODEL_LOCAL_VIEWER, CONTEXT_BOOL(Light.Model.LocalViewer), NO_EXTRA },
    { GL_LINE_STIPPLE, CONTEXT_BOOL(Line.StippleFlag), NO_EXTRA },
    { GL_LINE_STIPPLE_PATTERN, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_LINE_STIPPLE_REPEAT, CONTEXT_INT(Line.StippleFactor), NO_EXTRA },
    { GL_LINE_WIDTH_GRANULARITY, CONTEXT_FLOAT(Const.LineWidthGranularity), NO_EXTRA },
    { GL_LIST_BASE, CONTEXT_INT(List.ListBase), NO_EXTRA },
    { GL_LIST_INDEX, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_LIST_MODE, LOC_CUSTOM, TYPE_ENUM, 0, NO_EXTRA },
    { GL_INDEX_LOGIC_OP, CONTEXT_BOOL(Color.IndexLogicOpEnabled), NO_EXTRA },
    { GL_MAP1_COLOR_4, CONTEXT_BOOL(Eval.Map1Color4), NO_EXTRA },
    { GL_MAP1_GRID_DOMAIN, CONTEXT_FLOAT2(Eval.MapGrid1u1), NO_EXTRA },
    { GL_MAP1_GRID_SEGMENTS, CONTEXT_INT(Eval.MapGrid1un), NO_EXTRA },
    { GL_MAP1_INDEX, CONTEXT_BOOL(Eval.Map1Index), NO_EXTRA },
    { GL_MAP1_NORMAL, CONTEXT_BOOL(Eval.Map1Normal), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_1, CONTEXT_BOOL(Eval.Map1TextureCoord1), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_2, CONTEXT_BOOL(Eval.Map1TextureCoord2), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_3, CONTEXT_BOOL(Eval.Map1TextureCoord3), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_4, CONTEXT_BOOL(Eval.Map1TextureCoord4), NO_EXTRA },
    { GL_MAP1_VERTEX_3, CONTEXT_BOOL(Eval.Map1Vertex3), NO_EXTRA },
    { GL_MAP1_VERTEX_4, CONTEXT_BOOL(Eval.Map1Vertex4), NO_EXTRA },
    { GL_MAP2_COLOR_4, CONTEXT_BOOL(Eval.Map2Color4), NO_EXTRA },
    { GL_MAP2_GRID_DOMAIN, LOC_CUSTOM, TYPE_FLOAT_4, 0, NO_EXTRA },
    { GL_MAP2_GRID_SEGMENTS, CONTEXT_INT2(Eval.MapGrid2un), NO_EXTRA },
    { GL_MAP2_INDEX, CONTEXT_BOOL(Eval.Map2Index), NO_EXTRA },
    { GL_MAP2_NORMAL, CONTEXT_BOOL(Eval.Map2Normal), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_1, CONTEXT_BOOL(Eval.Map2TextureCoord1), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_2, CONTEXT_BOOL(Eval.Map2TextureCoord2), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_3, CONTEXT_BOOL(Eval.Map2TextureCoord3), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_4, CONTEXT_BOOL(Eval.Map2TextureCoord4), NO_EXTRA },
    { GL_MAP2_VERTEX_3, CONTEXT_BOOL(Eval.Map2Vertex3), NO_EXTRA },
    { GL_MAP2_VERTEX_4, CONTEXT_BOOL(Eval.Map2Vertex4), NO_EXTRA },
    { GL_MAP_COLOR, CONTEXT_BOOL(Pixel.MapColorFlag), NO_EXTRA },
    { GL_MAP_STENCIL, CONTEXT_BOOL(Pixel.MapStencilFlag), NO_EXTRA },
    { GL_MAX_ATTRIB_STACK_DEPTH, CONST(MAX_ATTRIB_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_CLIENT_ATTRIB_STACK_DEPTH, CONST(MAX_CLIENT_ATTRIB_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_EVAL_ORDER, CONST(MAX_EVAL_ORDER), NO_EXTRA },
    { GL_MAX_LIST_NESTING, CONST(MAX_LIST_NESTING), NO_EXTRA },
    { GL_MAX_NAME_STACK_DEPTH, CONST(MAX_NAME_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_PIXEL_MAP_TABLE, CONST(MAX_PIXEL_MAP_TABLE), NO_EXTRA },
    { GL_NAME_STACK_DEPTH, CONTEXT_INT(Select.NameStackDepth), NO_EXTRA },
    { GL_PACK_LSB_FIRST, CONTEXT_BOOL(Pack.LsbFirst), NO_EXTRA },
    { GL_PACK_SWAP_BYTES, CONTEXT_BOOL(Pack.SwapBytes), NO_EXTRA },
    { GL_PACK_INVERT_MESA, CONTEXT_BOOL(Pack.Invert), NO_EXTRA },
    { GL_PIXEL_MAP_A_TO_A_SIZE, CONTEXT_INT(PixelMaps.AtoA.Size), NO_EXTRA },
    { GL_PIXEL_MAP_B_TO_B_SIZE, CONTEXT_INT(PixelMaps.BtoB.Size), NO_EXTRA },
    { GL_PIXEL_MAP_G_TO_G_SIZE, CONTEXT_INT(PixelMaps.GtoG.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_A_SIZE, CONTEXT_INT(PixelMaps.ItoA.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_B_SIZE, CONTEXT_INT(PixelMaps.ItoB.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_G_SIZE, CONTEXT_INT(PixelMaps.ItoG.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_I_SIZE, CONTEXT_INT(PixelMaps.ItoI.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_R_SIZE, CONTEXT_INT(PixelMaps.ItoR.Size), NO_EXTRA },
    { GL_PIXEL_MAP_R_TO_R_SIZE, CONTEXT_INT(PixelMaps.RtoR.Size), NO_EXTRA },
    { GL_PIXEL_MAP_S_TO_S_SIZE, CONTEXT_INT(PixelMaps.StoS.Size), NO_EXTRA },
    { GL_POINT_SIZE_GRANULARITY, CONTEXT_FLOAT(Const.PointSizeGranularity), NO_EXTRA },
    { GL_POLYGON_MODE, CONTEXT_ENUM2(Polygon.FrontMode), NO_EXTRA },
    { GL_POLYGON_OFFSET_BIAS_EXT, CONTEXT_FLOAT(Polygon.OffsetUnits), NO_EXTRA },
    { GL_POLYGON_OFFSET_POINT, CONTEXT_BOOL(Polygon.OffsetPoint), NO_EXTRA },
    { GL_POLYGON_OFFSET_LINE, CONTEXT_BOOL(Polygon.OffsetLine), NO_EXTRA },
    { GL_POLYGON_SMOOTH, CONTEXT_BOOL(Polygon.SmoothFlag), NO_EXTRA },
    { GL_POLYGON_SMOOTH_HINT, CONTEXT_ENUM(Hint.PolygonSmooth), NO_EXTRA },
    { GL_POLYGON_STIPPLE, CONTEXT_BOOL(Polygon.StippleFlag), NO_EXTRA },
    { GL_RED_BIAS, CONTEXT_FLOAT(Pixel.RedBias), NO_EXTRA },
    { GL_RED_SCALE, CONTEXT_FLOAT(Pixel.RedScale), NO_EXTRA },
    { GL_RENDER_MODE, CONTEXT_ENUM(RenderMode), NO_EXTRA },
    { GL_RGBA_MODE, CONST(1), NO_EXTRA },
    { GL_SELECTION_BUFFER_SIZE, CONTEXT_INT(Select.BufferSize), NO_EXTRA },
    { GL_STEREO, BUFFER_INT(Visual.stereoMode), NO_EXTRA },
    { GL_TEXTURE_1D, LOC_CUSTOM, TYPE_BOOLEAN, NO_OFFSET, NO_EXTRA },
    { GL_TEXTURE_3D, LOC_CUSTOM, TYPE_BOOLEAN, NO_OFFSET, NO_EXTRA },
    { GL_TEXTURE_BINDING_1D, LOC_CUSTOM, TYPE_INT, TEXTURE_1D_INDEX, NO_EXTRA },
    { GL_TEXTURE_BINDING_1D_ARRAY, LOC_CUSTOM, TYPE_INT, TEXTURE_1D_ARRAY_INDEX, extra_EXT_texture_array },
    { GL_TEXTURE_GEN_S, LOC_TEXUNIT, TYPE_BIT_0, offsetof(struct gl_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_TEXTURE_GEN_T, LOC_TEXUNIT, TYPE_BIT_1, offsetof(struct gl_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_TEXTURE_GEN_R, LOC_TEXUNIT, TYPE_BIT_2, offsetof(struct gl_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_TEXTURE_GEN_Q, LOC_TEXUNIT, TYPE_BIT_3, offsetof(struct gl_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_UNPACK_LSB_FIRST, CONTEXT_BOOL(Unpack.LsbFirst), NO_EXTRA },
    { GL_UNPACK_SWAP_BYTES, CONTEXT_BOOL(Unpack.SwapBytes), NO_EXTRA },
    { GL_ZOOM_X, CONTEXT_FLOAT(Pixel.ZoomX), NO_EXTRA },
    { GL_ZOOM_Y, CONTEXT_FLOAT(Pixel.ZoomY), NO_EXTRA },
    { GL_VERTEX_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_NORMAL_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_COLOR_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_INDEX_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_COLOR_INDEX].Enabled), NO_EXTRA },
    { GL_INDEX_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_COLOR_INDEX].Type), NO_EXTRA },
    { GL_INDEX_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_COLOR_INDEX].Stride), NO_EXTRA },
    { GL_INDEX_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_EDGEFLAG].Enabled), NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_EDGEFLAG].Stride), NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_TEXTURE_COMPRESSION_HINT_ARB, CONTEXT_INT(Hint.TextureCompression), NO_EXTRA },
    { GL_ARRAY_ELEMENT_LOCK_FIRST_EXT, CONTEXT_INT(Array.LockFirst), NO_EXTRA },
    { GL_ARRAY_ELEMENT_LOCK_COUNT_EXT, CONTEXT_INT(Array.LockCount), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_WIDTH, CONTEXT_INT(Unpack.CompressedBlockWidth), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_HEIGHT, CONTEXT_INT(Unpack.CompressedBlockHeight), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_DEPTH, CONTEXT_INT(Unpack.CompressedBlockDepth), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_SIZE, CONTEXT_INT(Unpack.CompressedBlockSize), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_WIDTH, CONTEXT_INT(Pack.CompressedBlockWidth), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_HEIGHT, CONTEXT_INT(Pack.CompressedBlockHeight), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_DEPTH, CONTEXT_INT(Pack.CompressedBlockDepth), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_SIZE, CONTEXT_INT(Pack.CompressedBlockSize), NO_EXTRA },
    { GL_TRANSPOSE_MODELVIEW_MATRIX_ARB, CONTEXT_MATRIX_T(ModelviewMatrixStack), NO_EXTRA },
    { GL_TRANSPOSE_PROJECTION_MATRIX_ARB, CONTEXT_MATRIX_T(ProjectionMatrixStack.Top), NO_EXTRA },
    { GL_TRANSPOSE_TEXTURE_MATRIX_ARB, CONTEXT_MATRIX_T(TextureMatrixStack), NO_EXTRA },
    { GL_COLOR_SUM, CONTEXT_BOOL(Fog.ColorSumEnabled), NO_EXTRA },
    { GL_CURRENT_SECONDARY_COLOR, CONTEXT_FIELD(Current.Attrib[VERT_ATTRIB_COLOR1][0], TYPE_FLOATN_4), extra_flush_current },
    { GL_SECONDARY_COLOR_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_COLOR1].Enabled), NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_COLOR1].Type), NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_COLOR1].Stride), NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_SIZE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_CURRENT_FOG_COORDINATE, CONTEXT_FLOAT(Current.Attrib[VERT_ATTRIB_FOG][0]), extra_flush_current },
    { GL_FOG_COORDINATE_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_FOG].Enabled), NO_EXTRA },
    { GL_FOG_COORDINATE_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_FOG].Type), NO_EXTRA },
    { GL_FOG_COORDINATE_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_FOG].Stride), NO_EXTRA },
    { GL_FOG_COORDINATE_SOURCE, CONTEXT_ENUM(Fog.FogCoordinateSource), NO_EXTRA },
    { GL_FOG_DISTANCE_MODE_NV, CONTEXT_ENUM(Fog.FogDistanceMode), extra_NV_fog_distance },
    { GL_RASTER_POSITION_UNCLIPPED_IBM, CONTEXT_BOOL(Transform.RasterPositionUnclipped), NO_EXTRA },
    { GL_POINT_SPRITE_R_MODE_NV, CONTEXT_ENUM(Point.SpriteRMode), extra_NV_point_sprite },
    { GL_POINT_SPRITE_COORD_ORIGIN, CONTEXT_ENUM(Point.SpriteOrigin), extra_NV_point_sprite_ARB_point_sprite },
    { GL_TEXTURE_RECTANGLE_NV, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_NV_texture_rectangle },
    { GL_TEXTURE_BINDING_RECTANGLE_NV, LOC_CUSTOM, TYPE_INT, TEXTURE_RECT_INDEX, extra_NV_texture_rectangle },
    { GL_MAX_RECTANGLE_TEXTURE_SIZE_NV, CONTEXT_INT(Const.MaxTextureRectSize), extra_NV_texture_rectangle },
    { GL_STENCIL_TEST_TWO_SIDE_EXT, CONTEXT_BOOL(Stencil.TestTwoSide), extra_EXT_stencil_two_side },
    { GL_ACTIVE_STENCIL_FACE_EXT, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, NO_EXTRA },
    { GL_MAX_SHININESS_NV, CONTEXT_FLOAT(Const.MaxShininess), NO_EXTRA },
    { GL_MAX_SPOT_EXPONENT_NV, CONTEXT_FLOAT(Const.MaxSpotExponent), NO_EXTRA },
    { GL_PRIMITIVE_RESTART_NV, CONTEXT_BOOL(Array.PrimitiveRestart), extra_NV_primitive_restart },
    { GL_PRIMITIVE_RESTART_INDEX_NV, CONTEXT_INT(Array.RestartIndex), extra_NV_primitive_restart },
    { GL_INDEX_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_COLOR_INDEX].BufferObj), NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_EDGEFLAG].BufferObj), NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_COLOR1].BufferObj), NO_EXTRA },
    { GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_FOG].BufferObj), NO_EXTRA },
    { GL_VERTEX_PROGRAM_ARB, CONTEXT_BOOL(VertexProgram.Enabled), extra_ARB_vertex_program },
    { GL_VERTEX_PROGRAM_POINT_SIZE_ARB, CONTEXT_BOOL(VertexProgram.PointSizeEnabled), extra_ARB_vertex_program },
    { GL_VERTEX_PROGRAM_TWO_SIDE_ARB, CONTEXT_BOOL(VertexProgram.TwoSideEnabled), extra_ARB_vertex_program },
    { GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB, CONTEXT_INT(Const.MaxProgramMatrixStackDepth), extra_ARB_vertex_program_ARB_fragment_program },
    { GL_MAX_PROGRAM_MATRICES_ARB, CONTEXT_INT(Const.MaxProgramMatrices), extra_ARB_vertex_program_ARB_fragment_program },
    { GL_CURRENT_MATRIX_STACK_DEPTH_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_vertex_program_ARB_fragment_program },
    { GL_CURRENT_MATRIX_ARB, LOC_CUSTOM, TYPE_MATRIX, 0, extra_ARB_vertex_program_ARB_fragment_program },
    { GL_TRANSPOSE_CURRENT_MATRIX_ARB, LOC_CUSTOM, TYPE_MATRIX_T, 0, extra_ARB_vertex_program_ARB_fragment_program },
    { GL_PROGRAM_ERROR_POSITION_ARB, CONTEXT_INT(Program.ErrorPos), extra_ARB_vertex_program_ARB_fragment_program },
    { GL_FRAGMENT_PROGRAM_ARB, CONTEXT_BOOL(FragmentProgram.Enabled), extra_ARB_fragment_program },
    { GL_RGBA_SIGNED_COMPONENTS_EXT, LOC_CUSTOM, TYPE_INT_4, 0, extra_EXT_packed_float },
    { GL_DEPTH_BOUNDS_TEST_EXT, CONTEXT_BOOL(Depth.BoundsTest), extra_EXT_depth_bounds_test },
    { GL_DEPTH_BOUNDS_EXT, CONTEXT_FLOAT2(Depth.BoundsMin), extra_EXT_depth_bounds_test },
    { GL_DEPTH_CLAMP, CONTEXT_BOOL(Transform.DepthClamp), extra_ARB_depth_clamp },
    { GL_NUM_FRAGMENT_REGISTERS_ATI, CONST(6), extra_ATI_fragment_shader },
    { GL_NUM_FRAGMENT_CONSTANTS_ATI, CONST(8), extra_ATI_fragment_shader },
    { GL_NUM_PASSES_ATI, CONST(2), extra_ATI_fragment_shader },
    { GL_NUM_INSTRUCTIONS_PER_PASS_ATI, CONST(8), extra_ATI_fragment_shader },
    { GL_NUM_INSTRUCTIONS_TOTAL_ATI, CONST(16), extra_ATI_fragment_shader },
    { GL_COLOR_ALPHA_PAIRING_ATI, CONST(GL_TRUE), extra_ATI_fragment_shader },
    { GL_NUM_LOOPBACK_COMPONENTS_ATI, CONST(3), extra_ATI_fragment_shader },
    { GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI, CONST(3), extra_ATI_fragment_shader },
    { GL_PROVOKING_VERTEX_EXT, CONTEXT_ENUM(Light.ProvokingVertex), extra_EXT_provoking_vertex },
    { GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT, CONTEXT_BOOL(Const.QuadsFollowProvokingVertexConvention), extra_EXT_provoking_vertex },
    { GL_TEXTURE_CUBE_MAP_SEAMLESS, CONTEXT_BOOL(Texture.CubeMapSeamless), extra_ARB_seamless_cube_map },
    { GL_RGBA_INTEGER_MODE_EXT, BUFFER_BOOL(_IntegerColor), extra_EXT_texture_integer_and_new_buffers },
    { GL_MAX_TRANSFORM_FEEDBACK_BUFFERS, CONTEXT_INT(Const.MaxTransformFeedbackBuffers), extra_ARB_transform_feedback3 },
    { GL_MAX_VERTEX_STREAMS, CONTEXT_INT(Const.MaxVertexStreams), extra_ARB_transform_feedback3_ARB_gpu_shader5 },
    { GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxTextureImageUnits), extra_gl32_ARB_geometry_shader4 },
    { GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB, CONTEXT_INT(Const.MaxGeometryOutputVertices), extra_gl32_ARB_geometry_shader4 },
    { GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB, CONTEXT_INT(Const.MaxGeometryTotalOutputComponents), extra_gl32_ARB_geometry_shader4 },
    { GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxUniformComponents), extra_gl32_ARB_geometry_shader4 },
    { GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxOutputComponents), extra_ARB_geometry_shader4 },
    { GL_MAX_VERTEX_VARYING_COMPONENTS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxOutputComponents), extra_ARB_geometry_shader4 },
    { GL_RGBA_FLOAT_MODE_ARB, BUFFER_FIELD(Visual.floatMode, TYPE_BOOLEAN), extra_core_ARB_color_buffer_float_and_new_buffers },
    { GL_MAX_TEXTURE_BUFFER_SIZE_ARB, CONTEXT_INT(Const.MaxTextureBufferSize), extra_texture_buffer_object },
    { GL_TEXTURE_BINDING_BUFFER_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_texture_buffer_object },
    { GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB, LOC_CUSTOM, TYPE_INT, TEXTURE_BUFFER_INDEX, extra_texture_buffer_object },
    { GL_TEXTURE_BUFFER_FORMAT_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_texture_buffer_object },
    { GL_TEXTURE_BUFFER_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_texture_buffer_object },
    { GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_MULTISAMPLE_ARRAY_INDEX, extra_ARB_texture_multisample },
    { GL_CONTEXT_FLAGS, CONTEXT_INT(Const.ContextFlags), extra_version_30 },
    { GL_FRAMEBUFFER_SRGB_EXT, CONTEXT_BOOL(Color.sRGBEnabled), extra_EXT_framebuffer_sRGB },
    { GL_FRAMEBUFFER_SRGB_CAPABLE_EXT, BUFFER_INT(Visual.sRGBCapable), extra_EXT_framebuffer_sRGB_and_new_buffers },
    { GL_PRIMITIVE_RESTART, CONTEXT_BOOL(Array.PrimitiveRestart), extra_version_31 },
    { GL_PRIMITIVE_RESTART_INDEX, CONTEXT_INT(Array.RestartIndex), extra_version_31 },
    { GL_CONTEXT_PROFILE_MASK, CONTEXT_INT(Const.ProfileMask), extra_version_32 },
    { GL_MAX_GEOMETRY_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxInputComponents), extra_version_32 },
    { GL_MAX_GEOMETRY_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxOutputComponents), extra_version_32 },
    { GL_MAX_VERTEX_ATTRIB_STRIDE, CONTEXT_ENUM(Const.MaxVertexAttribStride), NO_EXTRA },
    { GL_RESET_NOTIFICATION_STRATEGY_ARB, CONTEXT_ENUM(Const.ResetStrategy), NO_EXTRA },
    { GL_DEBUG_LOGGED_MESSAGES, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MAX_DEBUG_LOGGED_MESSAGES, CONST(MAX_DEBUG_LOGGED_MESSAGES), NO_EXTRA },
    { GL_MAX_DEBUG_MESSAGE_LENGTH, CONST(MAX_DEBUG_MESSAGE_LENGTH), NO_EXTRA },
    { GL_MAX_LABEL_LENGTH, CONST(MAX_LABEL_LENGTH), NO_EXTRA },
    { GL_MAX_DEBUG_GROUP_STACK_DEPTH, CONST(MAX_DEBUG_GROUP_STACK_DEPTH), NO_EXTRA },
    { GL_DEBUG_GROUP_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MAX_DUAL_SOURCE_DRAW_BUFFERS, CONTEXT_INT(Const.MaxDualSourceDrawBuffers), extra_ARB_blend_func_extended },
    { GL_MAX_GEOMETRY_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxUniformBlocks), extra_ARB_uniform_buffer_object_and_geometry_shader },
    { GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxCombinedUniformComponents), extra_ARB_uniform_buffer_object_and_geometry_shader },
    { GL_TIMESTAMP, LOC_CUSTOM, TYPE_INT64, 0, extra_ARB_timer_query },
    { GL_MIN_MAP_BUFFER_ALIGNMENT, CONTEXT_INT(Const.MinMapBufferAlignment), NO_EXTRA },
    { GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB, LOC_CUSTOM, TYPE_INT, TEXTURE_CUBE_ARRAY_INDEX, extra_ARB_texture_cube_map_array },
    { GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB, CONTEXT_INT(Const.MaxProgramTextureGatherComponents), extra_ARB_texture_gather },
    { GL_PROGRAM_PIPELINE_BINDING, LOC_CUSTOM, TYPE_INT, GL_PROGRAM_PIPELINE_BINDING, NO_EXTRA },
    { GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_and_geometry_shader },
    { GL_MAX_GEOMETRY_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxAtomicCounters), extra_ARB_shader_atomic_counters_and_geometry_shader },
    { GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET, CONTEXT_ENUM(Const.MaxVertexAttribRelativeOffset), NO_EXTRA },
    { GL_MAX_VERTEX_ATTRIB_BINDINGS, CONTEXT_ENUM(Const.MaxVertexAttribBindings), NO_EXTRA },
    { GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS, CONTEXT_INT(Const.MaxCombinedShaderOutputResources), extra_ARB_shader_image_load_store },
    { GL_MAX_IMAGE_SAMPLES, CONTEXT_INT(Const.MaxImageSamples), extra_ARB_shader_image_load_store },
    { GL_MAX_GEOMETRY_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxImageUniforms), extra_ARB_shader_image_load_store_and_geometry_shader },
    { GL_MAX_FRAMEBUFFER_WIDTH, CONTEXT_INT(Const.MaxFramebufferWidth), extra_ARB_framebuffer_no_attachments },
    { GL_MAX_FRAMEBUFFER_HEIGHT, CONTEXT_INT(Const.MaxFramebufferHeight), extra_ARB_framebuffer_no_attachments },
    { GL_MAX_FRAMEBUFFER_LAYERS, CONTEXT_INT(Const.MaxFramebufferLayers), extra_ARB_framebuffer_no_attachments },
    { GL_MAX_FRAMEBUFFER_SAMPLES, CONTEXT_INT(Const.MaxFramebufferSamples), extra_ARB_framebuffer_no_attachments },
    { GL_POLYGON_OFFSET_CLAMP_EXT, CONTEXT_FLOAT(Polygon.OffsetClamp), extra_EXT_polygon_offset_clamp },
    { GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT, CONTEXT_INT(Const.TextureBufferOffsetAlignment), extra_ARB_texture_buffer_range },
    { GL_MAX_VIEWPORTS, CONTEXT_INT(Const.MaxViewports), extra_ARB_viewport_array },
    { GL_VIEWPORT_SUBPIXEL_BITS, CONTEXT_INT(Const.ViewportSubpixelBits), extra_ARB_viewport_array },
    { GL_VIEWPORT_BOUNDS_RANGE, CONTEXT_FLOAT2(Const.ViewportBounds), extra_ARB_viewport_array },
    { GL_LAYER_PROVOKING_VERTEX, CONTEXT_ENUM(Light.ProvokingVertex), extra_ARB_viewport_array },
    { GL_VIEWPORT_INDEX_PROVOKING_VERTEX, CONTEXT_ENUM(Light.ProvokingVertex), extra_ARB_viewport_array },
    { GL_MAX_GEOMETRY_SHADER_INVOCATIONS, CONST(MAX_GEOMETRY_SHADER_INVOCATIONS), extra_ARB_gpu_shader5 },
    { GL_MIN_FRAGMENT_INTERPOLATION_OFFSET, CONTEXT_FLOAT(Const.MinFragmentInterpolationOffset), extra_ARB_gpu_shader5 },
    { GL_MAX_FRAGMENT_INTERPOLATION_OFFSET, CONTEXT_FLOAT(Const.MaxFragmentInterpolationOffset), extra_ARB_gpu_shader5 },
    { GL_FRAGMENT_INTERPOLATION_OFFSET_BITS, CONST(FRAGMENT_INTERPOLATION_OFFSET_BITS), extra_ARB_gpu_shader5 },
    { GL_PATCH_VERTICES, CONTEXT_INT(TessCtrlProgram.patch_vertices), extra_ARB_tessellation_shader },
    { GL_PATCH_DEFAULT_OUTER_LEVEL, CONTEXT_FLOAT4(TessCtrlProgram.patch_default_outer_level), extra_ARB_tessellation_shader },
    { GL_PATCH_DEFAULT_INNER_LEVEL, CONTEXT_FLOAT2(TessCtrlProgram.patch_default_inner_level), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_GEN_LEVEL, CONTEXT_INT(Const.MaxTessGenLevel), extra_ARB_tessellation_shader },
    { GL_MAX_PATCH_VERTICES, CONTEXT_INT(Const.MaxPatchVertices), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxUniformComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxUniformComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxTextureImageUnits), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxTextureImageUnits), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxOutputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_PATCH_COMPONENTS, CONTEXT_INT(Const.MaxTessPatchComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS, CONTEXT_INT(Const.MaxTessControlTotalOutputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxOutputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxInputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxInputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxUniformBlocks), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxUniformBlocks), extra_ARB_tessellation_shader },
    { GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxCombinedUniformComponents), extra_ARB_tessellation_shader },
    { GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxCombinedUniformComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxAtomicCounters), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxAtomicCounters), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxImageUniforms), extra_ARB_shader_image_load_store_and_tessellation },
    { GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxImageUniforms), extra_ARB_shader_image_load_store_and_tessellation },
    { GL_MAX_SUBROUTINES, CONST(MAX_SUBROUTINES), extra_ARB_shader_subroutine },
    { GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS, CONST(MAX_SUBROUTINE_UNIFORM_LOCATIONS), extra_ARB_shader_subroutine },
};

static table_t table_API_OPENGL = {
      82,  432,  370,    0,
     139,  199,    0,    0,
       0,  374,    0,  108,
     505,  537,    0,    0,
       0,    0,  291,  478,
     247,  226,    0,  541,
       0,    0,    0,  352,
       0,    0,    0,  375,
       0,    0,  180,    0,
       0,    0,  166,  151,
     407,  134,  140,    6,
       0,    0,    0,    0,
     303,    0,    0,  251,
     141,    0,  341,    0,
      64,  504,    0,    0,
       0,    0,  294,    0,
     475,    0,    0,  214,
       0,    0,  366,    0,
       0,  487,  298,  524,
     436,  399,  221,    0,
       0,  337,  500,  261,
     145,    0,    0,    0,
     234,   83,  433,    0,
       0,  144,    0,    0,
     110,  233,  343,    0,
     305,  506,  275,    0,
       0,    0,    0,  292,
     266,    0,  511,    0,
       0,    0,    0,    0,
     353,    0,    0,    0,
     124,    0,    0,  182,
     547,    0,    0,  167,
     262,   43,  118,    0,
     185,    0,    0,    0,
       0,  310,   73,    0,
       0,  311,    0,    0,
     133,    0,    0,    0,
     497,    0,  278,    0,
       0,  476,    0,    0,
     213,  455,    0,  367,
       0,    0,  488,  299,
     523,  437,  415,   80,
      20,    0,    0,  203,
     426,  149,  444,    0,
     333,  464,   84,    0,
     334,    0,  126,    0,
     477,  328,  249,  344,
       0,  316,    0,  277,
       0,    0,  460,    0,
     289,    0,    0,    0,
       0,  326,    0,    0,
       0,  354,    0,    0,
      42,  125,  229,    0,
     181,    0,    0,    0,
     168,  153,  208,  351,
     480,  187,    0,    0,
      96,    0,    0,   74,
       0,    0,  312,    0,
       0,  131,    0,    0,
     272,    0,  302,  463,
     496,  283,  471,  240,
       0,  215,    0,    0,
     368,    0,    0,  491,
       0,  521,  438,  416,
     223,   21,    0,    0,
     201,  427,  152,  318,
       0,  402,  465,   85,
       0,  400,  225,  138,
      39,    0,  112,  250,
       0,    0,  319,    0,
     271,   97,    0,  461,
       0,  290,    0,    0,
     470,    0,  327,    0,
       0,    0,  355,    0,
       0,  331,   23,  454,
       0,   44,    0,    0,
     387,  466,  154,  129,
     114,   54,  188,    0,
       0,    3,    0,    0,
       0,    0,    0,  105,
     392,    0,  132,  224,
       0,    0,    0,    0,
       0,  428,  535,  472,
     529,    0,    0,    0,
     348,  512,    0,    0,
     490,    0,    0,    0,
     330,  378,    0,    0,
     532,  202,    0,  420,
     409,    0,  323,  453,
      86,    0,    0,    0,
     143,   33,  365,  116,
     197,    0,    0,  317,
       0,  538,   98,    0,
       0,    0,    0,  483,
       0,    0,    0,    0,
       0,  314,    0,  356,
     304,  232,   29,  372,
     518,  493,  458,  186,
      50,  390,  169,  155,
     176,  451,    0,  189,
      30,    0,    2,    0,
       0,  514,    0,    0,
     380,  396,  207,  391,
       0,  519,    0,    0,
       0,    0,  474,    0,
       0,  241,    0,    0,
       0,  349,  513,    0,
       0,  489,    0,  462,
     373,  235,  177,  286,
       0,    0,   75,  258,
     156,  170,    0,  404,
     408,   87,    0,    0,
      93,   77,   35,    0,
     113,  198,   71,    0,
     320,    0,  539,   99,
       0,    0,    0,    0,
       0,    0,  456,  259,
     403,  502,    0,    0,
     357,    0,    0,   17,
       0,  230,  279,    0,
      46,   49,  388,  467,
     419,   25,    0,    0,
     190,   31,    0,    0,
       0,    0,  515,    0,
      12,    0,  398,    0,
     397,    0,    0,  536,
       0,    0,    0,    0,
       0,    0,  242,    0,
      27,    0,  359,  287,
       0,    0,    0,    0,
     510,   81,   68,  179,
       0,    0,    0,   76,
     481,  425,  411,    0,
       0,  256,   88,    0,
       0,   94,  531,   40,
       0,  115,    0,   72,
     117,  315,  486,    0,
     100,    0,    0,    0,
       0,  282,    0,  237,
     260,    0,  503,    0,
     358,    0,  200,  231,
       4,    0,  135,  280,
     459,  161,   52,  386,
     468,  421,   19,  449,
     401,  191,    0,    0,
     517,    0,  457,  534,
       0,   13,    0,  325,
       0,  450,    0,    0,
     274,    0,   55,    0,
       0,    0,    0,  244,
       0,  394,    0,  360,
     288,    0,    0,    0,
     163,    0,   78,   69,
     178,  254,    0,    0,
      61,  482,  146,  412,
       0,    0,    0,   89,
     121,    0,   95,    0,
      34,    0,  111,    0,
     265,   18,    0,    0,
     270,  101,    0,    0,
       0,    0,    0,  381,
     238,  424,    0,  501,
       0,  361,    0,  204,
       0,    1,    0,  136,
     281,    0,  160,   51,
     385,  164,  422,  406,
     442,    0,  192,    0,
       0,    0,    0,    0,
     122,    0,   14,    0,
       7,    0,  544,    0,
     525,  276,    0,   56,
       0,    0,  284,    0,
     243,    0,  395,    0,
       0,  293,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,    0,
       0,   62,    0,  147,
       0,    0,   63,    0,
     522,  346,  329,    0,
       0,   36,    0,    0,
      90,  540,  119,    0,
       0,    0,  102,    0,
       0,  222,    0,    0,
       0,  239,    0,    0,
     405,    0,  362,    0,
     205,    0,    9,    0,
     137,  236,    0,  439,
       0,  384,   57,  423,
       0,  443,    0,  193,
     492,    0,    0,    0,
       0,  128,    0,   10,
     309,    8,  183,  545,
     106,    0,  273,    0,
       0,    0,    0,  285,
       0,  245,    0,    0,
       0,  448,    0,    0,
     347,    0,    0,    0,
     376,  301,    0,  255,
       0,    0,   59,  452,
     148,    0,    0,   28,
     332,   53,  120,  307,
       0,    0,   37,    0,
       0,  338,    0,  342,
       0,    0,    0,  103,
       0,    0,  379,    0,
       0,    0,    0,    0,
     217,  142,    0,  363,
       0,  206,  484,   32,
       0,  109,  335,    0,
     440,  542,  389,  165,
     157,  175,  447,  269,
     194,    0,  218,  516,
      15,    0,   45,  210,
      11,  308,   16,  184,
     546,  313,  498,    0,
       0,    0,    0,    0,
       0,    0,  530,  227,
       0,    0,  543,    0,
     429,  350,    0,    0,
       0,  371,  322,    0,
     414,    0,    0,   60,
      66,  417,    0,  494,
      26,  336,  533,  473,
     306,  252,    0,   38,
     300,    0,   92,    0,
     339,    0,    0,    0,
     104,    0,    0,    0,
     526,    0,    0,    0,
       0,  216,    0,    0,
     364,    0,  479,  485,
     296,    0,  434,  162,
     528,  441,  267,  383,
      58,  158,  196,  445,
     324,  507,    0,  219,
     431,  369,    0,  127,
       0,    0,  469,    0,
     345,    0,  107,  509,
       0,    0,    0,    0,
       0,    0,    0,  246,
     228,    0,    0,    0,
       0,  430,   65,    0,
       0,    0,  123,  321,
       0,  413,    0,  418,
       0,   67,  150,    0,
     130,  393,    5,    0,
       0,   70,  253,    0,
      41,    0,    0,   91,
       0,  340,    0,    0,
       0,    0,    0,    0,
       0,  527,  520,    0,
     248,    0,  212,  410,
       0,   79,  495,  195,
     377,  297,  257,  435,
      47,  220,    0,  268,
     382,  499,  159,  209,
     446,  211,  508,    0,
};

static table_t table_API_OPENGLES = {
      82,    0,    0,    0,
     139,    0,    0,    0,
       0,    0,    0,  108,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  264,    0,    0,
       0,    0,    0,    0,
       0,    0,  166,  151,
       0,  134,  140,    6,
       0,    0,    0,    0,
       0,    0,    0,    0,
     141,    0,    0,    0,
      64,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     145,    0,    0,    0,
       0,   83,    0,    0,
       0,  144,    0,    0,
     110,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     124,    0,    0,    0,
       0,    0,    0,  167,
       0,   43,  118,    0,
       0,    0,    0,    0,
       0,    0,   73,    0,
       0,    0,    0,    0,
     133,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   80,
      20,    0,    0,    0,
       0,  149,    0,    0,
       0,    0,   84,    0,
       0,    0,  126,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  263,
      42,  125,    0,    0,
       0,    0,    0,    0,
     168,  153,    0,    0,
       0,    0,    0,    0,
      96,    0,    0,   74,
       0,    0,    0,    0,
       0,  131,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  172,    0,
       0,    0,    0,    0,
       0,   21,    0,    0,
       0,    0,  152,    0,
       0,    0,    0,   85,
       0,    0,    0,  138,
      39,    0,  112,    0,
       0,    0,    0,    0,
       0,   97,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   23,    0,
       0,   44,    0,    0,
       0,    0,  154,  129,
     114,   54,    0,    0,
       0,    3,    0,    0,
     171,    0,    0,  105,
       0,    0,  132,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  173,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      86,    0,    0,    0,
     143,   33,    0,  116,
       0,    0,    0,    0,
       0,    0,   98,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   29,    0,
       0,    0,    0,    0,
      50,    0,  169,  155,
       0,    0,    0,    0,
      30,    0,    2,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   75,    0,
     156,  170,    0,    0,
       0,   87,    0,    0,
      93,   77,   35,    0,
     113,    0,   71,    0,
       0,    0,    0,   99,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   17,
       0,    0,    0,    0,
      46,   49,    0,    0,
       0,   25,    0,    0,
       0,   31,    0,    0,
       0,    0,    0,    0,
      12,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      27,    0,    0,    0,
       0,    0,    0,    0,
       0,   81,   68,    0,
       0,    0,    0,   76,
       0,    0,    0,    0,
       0,    0,   88,    0,
       0,   94,    0,   40,
       0,  115,    0,   72,
     117,    0,    0,    0,
     100,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       4,    0,  135,    0,
       0,  161,   52,    0,
       0,    0,   19,    0,
       0,    0,    0,    0,
       0,    0,    0,  174,
       0,   13,    0,    0,
       0,    0,    0,    0,
       0,    0,   55,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     163,    0,   78,   69,
       0,    0,    0,    0,
      61,    0,  146,    0,
       0,    0,    0,   89,
     121,    0,   95,    0,
      34,    0,  111,    0,
       0,   18,    0,    0,
       0,  101,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    1,    0,  136,
       0,    0,  160,   51,
       0,  164,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     122,    0,   14,    0,
       7,    0,    0,    0,
       0,    0,    0,   56,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,    0,
       0,   62,    0,  147,
       0,    0,   63,    0,
       0,    0,    0,    0,
       0,   36,    0,    0,
      90,    0,  119,    0,
       0,    0,  102,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    9,    0,
     137,    0,    0,    0,
       0,    0,   57,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  128,    0,   10,
       0,    8,    0,    0,
     106,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   59,    0,
     148,    0,    0,   28,
       0,   53,  120,    0,
       0,    0,   37,    0,
       0,    0,    0,    0,
       0,    0,    0,  103,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  142,    0,    0,
       0,    0,    0,   32,
       0,  109,    0,    0,
       0,    0,    0,  165,
     157,    0,    0,    0,
       0,    0,    0,    0,
      15,    0,   45,    0,
      11,    0,   16,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   60,
      66,    0,    0,    0,
      26,    0,    0,    0,
       0,    0,    0,   38,
       0,    0,   92,    0,
       0,    0,    0,    0,
     104,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  162,
       0,    0,    0,    0,
      58,  158,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  127,
       0,    0,    0,    0,
       0,    0,  107,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   65,    0,
       0,    0,  123,    0,
       0,    0,    0,    0,
       0,   67,  150,    0,
     130,    0,    5,    0,
       0,   70,    0,    0,
      41,    0,    0,   91,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   79,    0,    0,
       0,    0,    0,    0,
      47,  225,    0,    0,
       0,    0,  159,    0,
       0,    0,    0,    0,
};

static table_t table_API_OPENGLES2 = {
     200,    0,    0,    0,
       0,  199,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  264,    0,    0,
       0,    0,  180,    0,
       0,    0,    0,    0,
       0,    0,    0,    6,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      64,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  214,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  221,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  204,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  182,
       0,    0,    0,    0,
       0,   43,    0,    0,
     185,    0,    0,    0,
       0,    0,   73,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     213,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   80,
      20,    0,    0,  203,
       0,    0,    0,    0,
       0,    0,  205,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  263,
      42,    0,    0,    0,
     181,    0,    0,    0,
       0,    0,  208,    0,
       0,  187,    0,    0,
       0,    0,    0,   74,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  215,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     223,   21,    0,    0,
     201,    0,    0,    0,
       0,    0,    0,  206,
       0,    0,    0,    0,
      39,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   23,    0,
       0,   44,    0,    0,
       0,    0,    0,    0,
       0,   54,  188,    0,
       0,    3,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  224,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  202,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   33,    0,    0,
     197,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   29,    0,
       0,    0,    0,  186,
      50,    0,    0,    0,
     176,    0,    0,  189,
      30,    0,    2,    0,
       0,    0,    0,    0,
       0,    0,  207,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  177,    0,
       0,    0,   75,    0,
       0,    0,    0,    0,
       0,  195,    0,    0,
     222,   77,   35,    0,
       0,  198,   71,    0,
       0,    0,    0,  211,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   17,
       0,    0,    0,    0,
      46,   49,    0,    0,
       0,   25,    0,    0,
     190,   31,    0,    0,
       0,    0,    0,    0,
      12,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      27,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   68,  179,
       0,    0,    0,   76,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   40,
       0,    0,    0,   72,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       4,    0,    0,    0,
       0,    0,   52,    0,
       0,    0,   19,    0,
       0,  191,    0,    0,
       0,    0,    0,    0,
       0,   13,    0,    0,
       0,    0,    0,    0,
       0,    0,   55,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   78,   69,
     178,    0,    0,    0,
      61,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      34,    0,    0,    0,
       0,   18,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    1,    0,    0,
       0,    0,    0,   51,
       0,    0,    0,    0,
       0,    0,  192,    0,
       0,    0,    0,    0,
       0,    0,   14,    0,
       7,    0,    0,    0,
       0,    0,    0,   56,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,    0,
       0,   62,    0,    0,
       0,    0,   63,    0,
       0,    0,    0,    0,
       0,   36,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    9,    0,
       0,    0,    0,    0,
       0,    0,   57,    0,
       0,    0,    0,  193,
       0,    0,    0,    0,
       0,    0,    0,   10,
       0,    8,  183,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   59,    0,
       0,    0,    0,   28,
       0,   53,    0,    0,
       0,    0,   37,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     217,    0,    0,    0,
       0,    0,    0,   32,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  175,    0,    0,
     194,    0,  218,    0,
      15,    0,   45,  210,
      11,    0,   16,  184,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   60,
      66,    0,    0,    0,
      26,    0,    0,    0,
       0,    0,    0,   38,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  216,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      58,    0,  196,    0,
       0,    0,    0,  219,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   65,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   67,    0,    0,
       0,    0,    5,    0,
       0,   70,    0,    0,
      41,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  212,    0,
       0,   79,    0,    0,
       0,    0,    0,    0,
      47,  220,    0,    0,
       0,    0,    0,  209,
       0,    0,    0,    0,
};

static table_t table_API_OPENGLES3 = {
     200,    0,    0,    0,
       0,  199,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     247,  226,    0,    0,
       0,    0,    0,    0,
       0,  264,    0,    0,
       0,    0,  180,    0,
       0,    0,    0,    0,
       0,    0,    0,    6,
       0,    0,    0,    0,
       0,    0,    0,  251,
       0,    0,    0,    0,
      64,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  214,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  221,    0,
       0,    0,    0,  261,
       0,    0,    0,    0,
     234,  204,    0,    0,
       0,    0,    0,    0,
       0,  233,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  182,
       0,    0,    0,    0,
     262,   43,    0,    0,
     185,    0,    0,    0,
       0,    0,   73,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     213,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   80,
      20,    0,    0,  203,
       0,    0,    0,    0,
       0,    0,  205,    0,
       0,    0,    0,    0,
       0,    0,  249,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  263,
      42,    0,  229,    0,
     181,    0,    0,    0,
       0,    0,  208,    0,
       0,  187,    0,    0,
       0,    0,    0,   74,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  240,
       0,  215,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     223,   21,    0,    0,
     201,    0,    0,    0,
       0,    0,    0,  206,
       0,    0,  225,    0,
      39,    0,    0,  250,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   23,    0,
       0,   44,    0,    0,
       0,    0,    0,    0,
       0,   54,  188,    0,
       0,    3,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  224,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  202,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   33,    0,    0,
     197,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  232,   29,    0,
       0,    0,    0,  186,
      50,    0,    0,    0,
     176,    0,    0,  189,
      30,    0,    2,    0,
       0,    0,    0,    0,
       0,    0,  207,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  241,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  235,  177,    0,
       0,    0,   75,  258,
       0,    0,    0,    0,
       0,  195,    0,    0,
     222,   77,   35,    0,
       0,  198,   71,    0,
       0,    0,    0,  211,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   17,
       0,  230,    0,    0,
      46,   49,    0,    0,
       0,   25,    0,    0,
     190,   31,    0,    0,
       0,    0,    0,    0,
      12,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  242,    0,
      27,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   68,  179,
       0,    0,    0,   76,
       0,    0,    0,    0,
       0,  256,    0,    0,
       0,    0,    0,   40,
       0,    0,    0,   72,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  237,
       0,    0,    0,    0,
       0,    0,    0,  231,
       4,    0,    0,    0,
       0,    0,   52,    0,
       0,    0,   19,    0,
       0,  191,    0,    0,
       0,    0,    0,    0,
       0,   13,    0,  295,
       0,    0,    0,    0,
       0,    0,   55,    0,
       0,    0,    0,  244,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   78,   69,
     178,  254,    0,    0,
      61,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      34,    0,    0,    0,
       0,   18,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     238,    0,    0,    0,
       0,    0,    0,    0,
       0,    1,    0,    0,
       0,    0,    0,   51,
       0,    0,    0,    0,
       0,    0,  192,    0,
       0,    0,    0,    0,
       0,    0,   14,    0,
       7,    0,    0,    0,
       0,    0,    0,   56,
       0,    0,    0,    0,
     243,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,    0,
       0,   62,    0,    0,
       0,    0,   63,    0,
       0,    0,    0,    0,
       0,   36,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  257,    0,    0,
       0,  239,    0,    0,
       0,    0,    0,    0,
       0,    0,    9,    0,
       0,  236,    0,    0,
       0,    0,   57,    0,
       0,    0,    0,  193,
       0,    0,    0,    0,
       0,    0,    0,   10,
       0,    8,  183,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  245,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  255,
       0,    0,   59,    0,
       0,    0,    0,   28,
       0,   53,    0,    0,
       0,    0,   37,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     217,    0,    0,    0,
       0,    0,    0,   32,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  175,    0,    0,
     194,    0,  218,    0,
      15,    0,   45,  210,
      11,    0,   16,  184,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  227,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   60,
      66,    0,    0,    0,
      26,    0,    0,    0,
       0,  252,    0,   38,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  216,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      58,  259,  196,    0,
       0,    0,    0,  219,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  246,
     228,    0,    0,    0,
       0,    0,   65,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   67,    0,    0,
       0,    0,    5,    0,
       0,   70,  253,    0,
      41,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     248,    0,  212,    0,
       0,   79,    0,    0,
       0,    0,    0,    0,
      47,  220,    0,    0,
       0,    0,  260,  209,
       0,    0,    0,    0,
};

static table_t table_API_OPENGLES31 = {
     200,    0,    0,    0,
       0,  199,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  291,    0,
     247,  226,    0,    0,
       0,    0,    0,    0,
       0,  264,    0,    0,
       0,    0,  180,    0,
       0,    0,    0,    0,
       0,    0,    0,    6,
       0,    0,    0,    0,
       0,    0,    0,  251,
       0,    0,    0,    0,
      64,    0,    0,    0,
       0,    0,  294,    0,
       0,    0,    0,  214,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  221,    0,
       0,    0,    0,  261,
       0,    0,    0,    0,
     234,  204,    0,    0,
       0,    0,    0,    0,
       0,  233,    0,    0,
       0,    0,  275,    0,
       0,    0,    0,  292,
     266,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  182,
       0,    0,    0,    0,
     262,   43,    0,    0,
     185,    0,    0,    0,
       0,    0,   73,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  278,    0,
       0,    0,    0,    0,
     213,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   80,
      20,    0,    0,  203,
       0,    0,    0,    0,
       0,    0,  205,    0,
       0,    0,    0,    0,
       0,    0,  249,    0,
       0,    0,    0,  277,
       0,    0,    0,    0,
     289,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  263,
      42,    0,  229,    0,
     181,    0,    0,    0,
       0,    0,  208,    0,
       0,  187,    0,    0,
       0,    0,    0,   74,
       0,    0,    0,    0,
       0,    0,    0,    0,
     272,    0,    0,    0,
       0,  283,    0,  240,
       0,  215,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     223,   21,    0,    0,
     201,    0,    0,    0,
       0,    0,    0,  206,
       0,    0,  225,    0,
      39,    0,    0,  250,
       0,    0,    0,    0,
     271,  269,    0,    0,
       0,  290,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   23,    0,
       0,   44,    0,    0,
       0,    0,    0,    0,
       0,   54,  188,    0,
       0,    3,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  224,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  202,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   33,    0,    0,
     197,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  232,   29,    0,
       0,    0,    0,  186,
      50,    0,    0,    0,
     176,    0,    0,  189,
      30,    0,    2,    0,
       0,    0,    0,    0,
       0,    0,  207,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  241,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  235,  177,  286,
       0,    0,   75,  258,
       0,    0,    0,    0,
       0,  195,    0,    0,
     222,   77,   35,    0,
       0,  198,   71,    0,
       0,    0,    0,  211,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   17,
       0,  230,  279,    0,
      46,   49,    0,    0,
       0,   25,    0,    0,
     190,   31,    0,    0,
       0,    0,    0,    0,
      12,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  242,    0,
      27,    0,    0,  287,
       0,    0,    0,    0,
       0,    0,   68,  179,
       0,    0,    0,   76,
       0,    0,    0,    0,
       0,  256,    0,    0,
       0,    0,    0,   40,
       0,    0,    0,   72,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  282,    0,  237,
       0,    0,    0,    0,
       0,    0,    0,  231,
       4,    0,    0,  280,
       0,    0,   52,    0,
       0,    0,   19,    0,
       0,  191,    0,    0,
       0,    0,    0,    0,
       0,   13,    0,  295,
       0,    0,    0,    0,
     274,    0,   55,    0,
       0,    0,    0,  244,
       0,    0,    0,    0,
     288,    0,    0,    0,
       0,    0,   78,   69,
     178,  254,    0,    0,
      61,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      34,    0,    0,    0,
     265,   18,    0,    0,
     270,    0,    0,    0,
       0,    0,    0,    0,
     238,    0,    0,    0,
       0,    0,    0,    0,
       0,    1,    0,    0,
     281,    0,    0,   51,
       0,    0,    0,    0,
       0,    0,  192,    0,
       0,    0,    0,    0,
       0,    0,   14,    0,
       7,    0,    0,    0,
       0,  276,    0,   56,
       0,    0,  284,    0,
     243,    0,    0,    0,
       0,  293,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,    0,
       0,   62,    0,    0,
       0,    0,   63,    0,
       0,    0,    0,    0,
       0,   36,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  257,    0,    0,
       0,  239,    0,    0,
       0,    0,    0,    0,
       0,    0,    9,    0,
       0,  236,    0,    0,
       0,    0,   57,    0,
       0,    0,    0,  193,
       0,    0,    0,    0,
       0,    0,    0,   10,
       0,    8,  183,    0,
       0,    0,  273,    0,
       0,    0,    0,  285,
       0,  245,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  255,
       0,    0,   59,    0,
       0,    0,    0,   28,
       0,   53,    0,    0,
       0,    0,   37,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     217,    0,    0,    0,
       0,    0,    0,   32,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  175,    0,    0,
     194,    0,  218,    0,
      15,    0,   45,  210,
      11,    0,   16,  184,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  227,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   60,
      66,    0,    0,    0,
      26,    0,    0,    0,
       0,  252,    0,   38,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  216,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  267,    0,
      58,  259,  196,    0,
       0,    0,    0,  219,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  246,
     228,    0,    0,    0,
       0,    0,   65,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   67,    0,    0,
       0,    0,    5,    0,
       0,   70,  253,    0,
      41,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     248,    0,  212,    0,
       0,   79,    0,    0,
       0,    0,    0,    0,
      47,  220,    0,  268,
       0,    0,  260,  209,
       0,    0,    0,    0,
};

static table_t table_API_OPENGL_CORE = {
      82,  432,  370,    0,
     139,  199,    0,    0,
       0,  374,    0,  108,
     505,  537,    0,    0,
       0,    0,  291,  478,
     247,  226,    0,  541,
       0,    0,    0,  352,
       0,    0,    0,  375,
     553,    0,  180,    0,
       0,    0,  166,  151,
     407,  134,  140,    6,
       0,    0,  556,    0,
     303,    0,    0,  251,
     141,    0,  341,    0,
      64,  504,    0,    0,
       0,  569,  294,    0,
     475,    0,    0,  214,
       0,    0,  366,  548,
       0,  487,  298,  524,
     436,  399,  221,    0,
       0,  337,  500,  261,
     145,    0,  565,    0,
     234,   83,  433,    0,
       0,  144,    0,    0,
     110,  233,  343,    0,
     305,  506,  275,    0,
       0,    0,    0,  292,
     266,    0,  511,    0,
       0,    0,    0,    0,
     353,    0,    0,    0,
     124,    0,    0,  182,
     547,    0,    0,  167,
     262,   43,  118,    0,
     185,    0,    0,  557,
       0,  310,   73,    0,
       0,  311,    0,    0,
     133,    0,    0,    0,
     497,  554,  278,    0,
       0,  476,    0,    0,
     213,  455,    0,  367,
       0,    0,  488,  299,
     523,  437,  415,   80,
      20,    0,    0,  203,
     426,  149,  444,  566,
     333,  464,   84,    0,
     334,    0,  126,    0,
     477,  328,  249,  344,
       0,  316,    0,  277,
       0,    0,  460,    0,
     289,    0,    0,  576,
       0,  326,    0,    0,
       0,  354,    0,    0,
      42,  125,  229,    0,
     181,    0,    0,    0,
     168,  153,  208,  351,
     480,  187,    0,    0,
      96,    0,    0,   74,
       0,    0,  312,    0,
       0,  131,    0,    0,
     272,    0,  302,  463,
     496,  283,  471,  240,
       0,  215,    0,    0,
     368,    0,    0,  491,
       0,  521,  438,  416,
     223,   21,    0,    0,
     201,  427,  152,  318,
       0,  402,  465,   85,
       0,  400,  225,  138,
      39,    0,  112,  250,
       0,    0,  319,    0,
     271,   97,    0,  461,
       0,  290,    0,    0,
     470,    0,  327,    0,
       0,    0,  355,    0,
       0,  331,   23,  454,
       0,   44,    0,    0,
     387,  466,  154,  129,
     114,   54,  188,    0,
       0,    3,    0,    0,
       0,    0,    0,  105,
     392,    0,  132,  224,
       0,  577,    0,    0,
       0,  428,  535,  472,
     529,    0,    0,  583,
     348,  512,    0,    0,
     490,    0,    0,    0,
     330,  378,    0,    0,
     532,  202,    0,  420,
     409,    0,  323,  453,
      86,    0,    0,    0,
     143,   33,  365,  116,
     197,    0,    0,  317,
       0,  538,   98,    0,
       0,  562,    0,  483,
       0,    0,    0,    0,
       0,  314,    0,  356,
     304,  232,   29,  372,
     518,  493,  458,  186,
      50,  390,  169,  155,
     176,  451,    0,  189,
      30,    0,    2,    0,
     572,  514,    0,    0,
     380,  396,  207,  391,
       0,  519,  579,    0,
       0,  573,  474,  549,
       0,  241,    0,    0,
     584,  349,  513,    0,
       0,  489,    0,  462,
     373,  235,  177,  286,
       0,    0,   75,  258,
     156,  170,    0,  404,
     408,   87,    0,    0,
      93,   77,   35,    0,
     113,  198,   71,    0,
     320,    0,  539,   99,
       0,    0,  561,    0,
       0,    0,  456,  259,
     403,  502,    0,    0,
     357,    0,    0,   17,
       0,  230,  279,    0,
      46,   49,  388,  467,
     419,   25,    0,    0,
     190,   31,    0,    0,
       0,    0,  515,    0,
      12,    0,  398,    0,
     397,    0,    0,  536,
       0,  552,  574,  560,
     550,    0,  242,    0,
      27,    0,  359,  287,
       0,    0,    0,  555,
     510,   81,   68,  179,
       0,    0,    0,   76,
     481,  425,  411,    0,
       0,  256,   88,    0,
       0,   94,  531,   40,
       0,  115,    0,   72,
     117,  315,  486,    0,
     100,    0,    0,  563,
       0,  282,    0,  237,
     260,    0,  503,    0,
     358,    0,  200,  231,
       4,    0,  135,  280,
     459,  161,   52,  386,
     468,  421,   19,  449,
     401,  191,    0,    0,
     517,    0,  457,  534,
       0,   13,    0,  295,
       0,  450,    0,    0,
     274,    0,   55,    0,
     559,  551,    0,  244,
       0,  394,    0,  360,
     288,    0,    0,    0,
     163,    0,   78,   69,
     178,  254,    0,    0,
      61,  482,  146,  412,
       0,    0,    0,   89,
     121,    0,   95,    0,
      34,    0,  111,    0,
     265,   18,    0,    0,
     270,  101,    0,    0,
     564,    0,    0,  381,
     238,  424,    0,  501,
       0,  361,    0,  204,
       0,    1,    0,  136,
     281,    0,  160,   51,
     385,  164,  422,  406,
     442,    0,  192,    0,
       0,    0,    0,    0,
     122,    0,   14,    0,
       7,  571,  544,    0,
     525,  276,    0,   56,
       0,    0,  284,    0,
     243,    0,  395,    0,
       0,  293,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,    0,
       0,   62,    0,  147,
       0,    0,   63,    0,
     522,  346,  329,    0,
       0,   36,    0,    0,
      90,  540,  119,    0,
       0,    0,  102,    0,
       0,  222,    0,    0,
       0,  239,    0,    0,
     405,    0,  362,    0,
     205,    0,    9,    0,
     137,  236,    0,  439,
     582,  384,   57,  423,
       0,  443,    0,  193,
     492,    0,    0,    0,
       0,  128,    0,   10,
     309,    8,  183,  545,
     106,    0,  273,    0,
       0,    0,    0,  285,
       0,  245,    0,    0,
       0,  448,    0,    0,
     347,    0,    0,    0,
     376,  301,    0,  255,
       0,    0,   59,  452,
     148,    0,    0,   28,
     332,   53,  120,  307,
       0,    0,   37,    0,
       0,  338,    0,  342,
       0,    0,    0,  103,
       0,    0,  379,    0,
       0,    0,    0,    0,
     217,  142,    0,  363,
       0,  206,  484,   32,
       0,  109,  335,    0,
     440,  542,  389,  165,
     157,  175,  447,  269,
     194,    0,  218,  516,
      15,    0,   45,  210,
      11,  308,   16,  184,
     546,  313,  498,  578,
       0,    0,    0,    0,
       0,    0,  530,  227,
     325,    0,  543,    0,
     429,  350,    0,    0,
       0,  371,  322,    0,
     414,    0,    0,   60,
      66,  417,    0,  494,
      26,  336,  533,  473,
     306,  252,    0,   38,
     300,    0,   92,    0,
     339,    0,    0,    0,
     104,    0,    0,  567,
     526,    0,    0,    0,
       0,  216,    0,    0,
     364,    0,  479,  485,
     296,    0,  434,  162,
     528,  441,  267,  383,
      58,  158,  196,  445,
     324,  507,    0,  219,
     431,  369,    0,  127,
     581,    0,  469,    0,
     345,    0,  107,  509,
     580,    0,    0,    0,
       0,  575,    0,  246,
     228,    0,    0,    0,
       0,  430,   65,    0,
       0,    0,  123,  321,
       0,  413,    0,  418,
       0,   67,  150,    0,
     130,  393,    5,    0,
     558,   70,  253,    0,
      41,    0,    0,   91,
       0,  340,    0,    0,
       0,  570,    0,    0,
     568,  527,  520,    0,
     248,    0,  212,  410,
       0,   79,  495,  195,
     377,  297,  257,  435,
      47,  220,    0,  268,
     382,  499,  159,  209,
     446,  211,  508,    0,
};

static table_t *table_set[] = {
   &table_API_OPENGL,
   &table_API_OPENGLES,
   &table_API_OPENGLES2,
   &table_API_OPENGL_CORE,
   &table_API_OPENGLES3,
   &table_API_OPENGLES31,
};

#define table(api) (*table_set[api])
